//[BotStacks Chat SDK](../../../index.md)/[ai.botstacks.sdk.ui.views](../index.md)/[ChannelSettingsState](index.md)

# ChannelSettingsState

@[Stable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Stable.html)

class [ChannelSettingsState](index.md)(chat: [Chat](../../ai.botstacks.sdk.state/-chat/index.md))

ChannelSettingsState

State holder for a given [Chat](../../ai.botstacks.sdk.state/-chat/index.md) channel, used specifically within the [ChannelSettingsView](../-channel-settings-view.md).

#### Parameters

common

| | |
|---|---|
| chat | The channel to initialize this state holder with.<br>To trigger an update/save once modifications are done within the view, simply call [update](update.md). This will return a Result with the updated chat if successful, or the error if it fails. While the save action is waiting for a result [saving](saving.md) will be true.<br>Resulting changes are persisted internally and do not need to be saved manually. |

## Constructors

| | |
|---|---|
| [ChannelSettingsState](-channel-settings-state.md) | [common]<br>constructor(chat: [Chat](../../ai.botstacks.sdk.state/-chat/index.md)) |

## Properties

| Name | Summary |
|---|---|
| [saving](saving.md) | [common]<br>var [saving](saving.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |

## Functions

| Name | Summary |
|---|---|
| [toggleMute](toggle-mute.md) | [common]<br>fun [toggleMute](toggle-mute.md)() |
| [update](update.md) | [common]<br>suspend fun [update](update.md)(): [Result](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-result/index.html)&lt;[Chat](../../ai.botstacks.sdk.state/-chat/index.md)?&gt; |
